/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public abstract class PendantItem
extends WearableArtifactItem {
    private final Supplier<Double> strikeChance;
    private final Supplier<Integer> cooldown;
    public static final List<BiConsumer<class_1309, class_1297>> LISTENERS = new ArrayList<BiConsumer<class_1309, class_1297>>();

    public PendantItem(Supplier<Double> strikeChance, Supplier<Integer> cooldown) {
        LISTENERS.add(this::onLivingHurt);
        this.strikeChance = strikeChance;
        this.cooldown = cooldown;
    }

    public double getStrikeChance() {
        return this.strikeChance.get();
    }

    protected void onLivingHurt(class_1309 entity, class_1297 attacker) {
        if (this.isEquippedBy(entity) && !entity.method_37908().method_8608() && attacker != null && !this.isOnCooldown(entity) && entity.method_6051().method_43058() < this.getStrikeChance() && attacker instanceof class_1309) {
            class_1309 livingEntity = (class_1309)attacker;
            this.applyEffect(entity, livingEntity);
            this.addCooldown(entity, this.cooldown.get());
        }
    }

    protected abstract void applyEffect(class_1309 var1, class_1309 var2);

    @Override
    protected boolean hasNonCosmeticEffects() {
        return this.getStrikeChance() > 0.0;
    }

    @Override
    public class_3414 getEquipSound() {
        return class_3417.field_15103;
    }
}

